from .StarCalculator import StarCalculator
from .PlanetCalculator import PlanetCalculator
from package.Journal.Events.Planet import Planet
from package.Journal.Events.Star import Star


#
# Values and formulas used from here:
# https://forums.frontier.co.uk/threads/exploration-value-formulae.232000/
#
# post by commander MattG
#
class Calculator:
    @staticmethod
    def calculateFromJournal(data, mapped=False, efficiencyBonus=False):
        # @deprecated
        value = 0

        if data.getParam('StarType') is not None:
            type = data.getParam('StarType')
            mass = data.getParam('StellarMass')
            value = StarCalculator.calculateValue(type, mass)
        elif data.getParam('PlanetClass') is not None:
            type = data.getParam('PlanetClass');
            mass = data.getParam('MassEM', 0);

            terraformState = data.getParam('TerraformState')
            terraformable = False
            if terraformState == "Terraformable" or terraformState == "Terraforming" or terraformState == "Terraformed":
                terraformable = True

            wasDiscovered = 1
            if (data.getParam('WasDiscovered') is False) and (data.getParam('WasMapped') is False):
                wasDiscovered = False

            wasMapped = 0
            if data.getParam('WasMapped') == True:
                wasMapped = 1

            value = PlanetCalculator.calculateValue(
                type,
                mass,
                terraformable,
                mapped,
                wasDiscovered,
                wasMapped,
                efficiencyBonus
            )

        return value

    @staticmethod
    def calculateFromData(type, mass, terraformable, mapped, wasDiscovered, wasMapped, efficiencyBonus):
        value = PlanetCalculator.calculateValue(
            type,
            mass,
            terraformable,
            mapped,
            wasDiscovered,
            wasMapped,
            efficiencyBonus
        )

        return value

    @staticmethod
    def calculate(body, mapped=False, efficiencyBonus=False):
        value = 0
        if isinstance(body, Star):
            value = StarCalculator.calculateValue(
                body.getType(),
                float(body.getMass())
            )
        elif isinstance(body, Planet):
            value = PlanetCalculator.calculateValue(
                body.getType(),
                body.getMass(),
                body.isTerraformable(),
                mapped,
                body.wasDiscovered(),
                body.wasMapped(),
                efficiencyBonus
            )
        return value
