from PyQt5.QtCore import QObject
from package.Journal.JournalFactory import JournalFactory
from package.Elite.Events import EVENTS


class LineHandler(QObject):
    def __init__(self):
        super(LineHandler, self).__init__()
        self.subscriber = {}
        self.initEvents()

    def initEvents(self):
        for eventName in EVENTS:
            self.subscriber[eventName] = []

    def registerSubscriber(self, object):
        eventName = object.getListenToEvent()
        self.subscriber[eventName].append(object)

    def processLine(self, jsonObject):
        event = JournalFactory.getEntityFromJournal(jsonObject)

        if (event is not None) and (event.getEvent() in self.subscriber):
            for eventHandler in self.subscriber[event.getEvent()]:
                eventHandler.notify(event)
