if __name__ == '__main__':
    import sys
    import logging
    from PyQt5 import QtWidgets
    from PyQt5 import QtGui
    from package.Ui.MainUi import MainUi
    from package.Database.DbFactory import DbFactory
    from package.Config.ConfigReader import ConfigReader
    from package.Config.ConfigManager import ConfigManager

    # create config reader
    ConfigReader.loadConfig()

    # logging stuff
    configData = ConfigReader.getConfigData()
    logging.basicConfig(
        filename=configData['Logging']['File'],
        level=configData['Logging']['Level'],
        format='%(asctime)s - %(levelname)s - %(message)s',
        datefmt='%d.%m.%Y %H:%M:%S'
    )

    # init available checker
    ConfigManager.initChecker()

    # create database object
    db = DbFactory.getDatabase()

    # create application & window
    app = QtWidgets.QApplication(sys.argv)

    appIcon = QtGui.QIcon("gui/images/icon.svg")
    app.setWindowIcon(appIcon)

    projectWindow = MainUi()
    projectWindow.init()
    projectWindow.show()
    sys.exit(app.exec_())
