import shutil


if __name__ == '__main__':
    import logging
    from package.Config.ConfigReader import ConfigReader
    from package.Installer.DbInstaller import DbInstaller

    # copy config file
    source = "./config/config.ini.dist"
    destination = "./config/config.ini"
    shutil.copy(source, destination)

    # create config reader
    ConfigReader.loadConfig()

    # logging stuff
    configData = ConfigReader.getConfigData()
    logging.basicConfig(
        filename=configData['Logging']['File'],
        level=configData['Logging']['Level'],
        format='%(asctime)s - %(levelname)s - %(message)s',
        datefmt='%d.%m.%Y %H:%M:%S'
    )

    installer = DbInstaller()
    installer.install()
