# CHANGELOG.md

## 1.4.1 (2024-03-31)

Bugfixes:
 - Fix error during with bio session update when scaning bark mounds
 - Fix error during mysql install

## 1.4.0 (2024-03-29)

Features:
 - Configurable checkers (for those where it makes sense)
 - New checker for gas giants with high amount of helium in atmosphere
 - added "selenium" to planet material check
 - Worth-Scanning rules will work for stars now

Misc:
 - Ring width checker takes no longer account of the parents radius, just the ring width matters
 - save/restore position of manage-checker window
 - removed message for water giants in Herbig Ae/Be systems - not really rare

## 1.3.0 (2024-01-03)

Features:
 - generate message if stellar phenomenas are detected
 - special search for tritium hotspots and stellar phenomena (see menu "Tools / Special search")

Bugfixes:
 - removed duplicate entries in planet statistics
 - fix progress bar progress during import

Misc:
 - scroll to top if a new search result is displayed in search window
 - mark clicked body in search window (element is dark gray)
 - when searching for a planet, the element is visible in the scroll window
 - added perihel and aphel to high eccentric orbits (> 0.9) in planet infos

## 1.2.1 (2023-09-02)

Misc:
 - added rotation period to star records

Bugfixes:
 - fix spectral class in statistics for wolf-rayet stars
 - fix crash when selecting landable planets in statistics

## 1.2 (2023-08-20)

Features:
 - statistics for planets/stars with rings

Bugfixes:
 - fixed typos
 - fixed error if a planet has no surface pressure value

## 1.1 (2023-07-19)

Features:
 - new setting to automatically reset credit count when exploration/bio data is sold
 - added option to include all star/planet types in statistic
 - open system view on double click in statistic table
 - new setting to display temperatures in kelvin or celsius

Bugfixes:
 - display distinct codex entries

## 1.00 (2023-06-10)

Features:
 - reworked ui
   - display scanned bio/geo signals
   - display hotspots in rings
   - search function for system & body names
   - moved existing tabs to individual windows
 - save window position when programm is closed and restore position on start
 - save variant data from ScanOrganic event

Bugfixes:

 - Fix crash when deleting imported data
 - When opening the window to create a new check, the name in the dropdown was inactive even if the check was not created
 - Fix crash when setting different "amount" options in statistics mode for planets and stars

Misc:

 - localized format for perihel and aphel in excentric check
 - reworked trojan check: semi major axis, inclination and eccentricity must be equal

## 0.10 (2023-02-26)

Features:

 - operator "not" for planet type
 - check "any" for atmosphere
 - show distance in close orbit check
 - display amount of sold exploration data
 - display estimated system value in system view
 - show organic scan value on first scan
 - track organic scan credits

Bugfixes:
 - preselect chosen screenshot format
 - get correct main star on location event if system has multiple stars
 - no longer possible to create 2 checks of the same type for a rule (because everything would break in this case) 

Misc:
 - updated calculation to include odyssey bonus
 - added image for wolf-rayet and o-stars

## 0.9.0 (2022-11-12)

Features:

 - new rule for rings (yes/no/ring type)
 - Choose screenshot format (png/jpg)

Bugfixes:

 - fixed a bug in worth scanning box if game crashes before entering a new system
 - only one message if moon is close to multiple rings
 - fixed screenshot conversion for windows

Misc:

 - added translation for notification settings
 - added missing pictures for s, cn, ms stars, black holes
 - copy ini file on install so updates won't override changes
 - added more options for the number of returned results for statistics

## 0.8.0 (2022-10-20)

Features:

 - Discovery scanner is always active
 - Desktop notifications

Bugfixes:

 - corrected rare planet messages
 - fixed "not landable" rule check
 - error handling in system analyzer to prevent messed up system states 

Misc:

- moved "reset credit count" button to main window
- added "landable" text to close orbit/moon close to ring check
- added ring type to wide/narrow ring checker
- generate only one "close binary" message
- localized number format on all values
- added missing picture for aebe stars
- added "silicate vapour" to atmosphere check

## 0.7.1 (2022-09-10)

Bugfixes:

 - fixed check for Class V gas giants

## 0.7.0 (2022-08-15)

Features:

 - update/migration feature in case of db changes in upcoming versions
 - tracking of bio / geo signals (FSSBodySignals, all SSASignals)
 - checker for amount of bio / geo signals

Misc:

 - reworked installation
 - added "none" to atmosphere check

Bugfixes:

 - display local time in flightlog

## 0.6.2 (2022-07-09)

Misc:

 - added atmosphere "Oxygen" to atmosphere check
 - focus system view window if another flightlog entry is clicked
 - added pictures for t-tauri and neutronstars 

Bugfixes:

 - sort flight log entries by date
 - fixed error when taking screenshots during a carrier jumpsequence

## 0.6.1 (2022-06-18)

Misc:

 - added atmosphere "Helium" to atmosphere check
 - display checker in scroll box
 - observer starts faster - optimized records checker (less queries to collect initial data)

## 0.6 (2022-06-02)

Features:

 - autosuggest for home system is now case insensitive
 - custom port for mysql connection
 - customizable rules for "worth scanning" planet. checks include:
   - planet type
   - landable yes/no
   - terraformable yes/no
   - gravity
   - temperature
   - atmosphere type
   - planet mass
 - added statistics:
   - number of total detail scans
   - number of total organic scans

Bugfixes:

 - if homesystem is changed while observer is running, new coordinates used for calculation
 - reduced false-positives for trojan check

## 0.5.4 (2022-03-22)

Features:

 - reworked db management gui
   - one button to start/stop import
   - new button to delete existing database (while keeping config settings)
 - check for potential trojan bodies (exprimental)

Bugfixes:

 - stop excessive use of file handles - one it enough
 - quit import thread if import is finished

Misc:

 - single mysql connection with keep-alive ping

## 0.5.3 (2022-03-15)

Bugfixes:

 - handle new names for journal files

## 0.5.2 (2022-03-14)

Bugfixes:

 - maintain correct flightlog when ship jumping with carrier while not in game
 - clear system state data on shutdown event
 - added picture for y stars
 - fix for overall import progress bar

## 0.5.1 (2022-02-20)

Bugfixes:

 - don't import logfiles from gameversion < 2.3 (missing "SystemAddress" breaks everything)
 - only print screenshot message if screenshot option is active
 - fix scaling bug in settings tab
 - move progress bar to 100% if a file is inserted completely
 - WAL journal mode for sqlite (optional but standard by default)
 - fixed crash in system checkers based on stars (missing method in star class)

Features:

  - add 50 and 100 in statistics amount dropdown
  - display state (running/stopped) of observer
  
## 0.5beta (2022-02-10)

Initial beta release